document.addEventListener("DOMContentLoaded", () => {
  setTimeout(load, 50);
  function load() {
    var params = location.href.split("?")[1].split("&");
    data = {};
    for (x in params) {
      data[params[x].split("=")[0]] = params[x].split("=")[1];
    }

    const constants = {
      en: {
        title: "Save Password in OctoPass?",
        website: "Website",
        password: "Password",
        passwordMessage: "Entered correctly?",
        description: "Your Description",
        descriptionMessage:
          "Did you enter it correctly? A personal description makes it easier to find saved passwords.",
        save: "Save",
      },
      de: {
        title: "Zugangsdaten in Octapass sichern ?",
        website: "Webseite",
        password: "Passwort",
        passwordMessage: "Korrekt eingegeben?",
        description: "Ihre Beschreibung",
        descriptionMessage:
          "Korrekt eingegeben?Eine persönliche Beschreibung erleichtert das Finden gespeicherter Passwörter.",
        save: "Speichern",
      },
    };

    /*==================== SELECTORS ====================*/
    document.getElementById("webAddress").innerText = data.website;
    document.getElementById("bar-password").value = data.password;
    const title = document.querySelector("#title");
    const website = document.querySelector("#website");
    const passwordMessage = document.querySelector("#password-message");
    const passwordLabel = document.querySelector("#password-label");
    const descriptionMessage = document.querySelector("#description-message");
    const descriptionLabel = document.querySelector("#description-label");
    const togglePassword = document.querySelector("#togglePassword");
    const password = document.querySelector("#bar-password");
    var addButton = document.querySelector(".octo-button-primary"),
      neverButton = document.querySelector(".octo-button-secondry");
    closeButton = document.querySelector(".octo-button-close");
    addButton.addEventListener("click", (e) => {
      // e.preventDefault();
      // chrome.tabs.getCurrent(ownTab => {
      //   chrome.tabs.sendMessage(ownTab.id,{status: 200, action: 'doSaveInfo', data: null}, data => {
      //     // process data here
      //   });
      // });
      e.preventDefault();
      var userDescription = document.getElementById("bar-description").value;
      var userPassword = document.getElementById("bar-password").value;
      sendPlatformMessage({
        command: "bgAddSave",
        data: { description: userDescription, password: userPassword },
      });
    });

    // TODO : FJ , Refacotr
    // neverButton.addEventListener('click', (e) => {
    //   e.preventDefault();
    //   chrome.tabs.getCurrent(ownTab => {
    //     chrome.tabs.sendMessage(ownTab.id,{status: 200, action: 'doNeverSaveInfo', data: null}, data => {
    //       // process data here
    //     });
    //   });
    // });
    title.textContent = constants[getLanguage()].title;
    website.textContent = constants[getLanguage()].website;
    passwordMessage.textContent = constants[getLanguage()].passwordMessage;
    passwordLabel.textContent = constants[getLanguage()].password;
    descriptionMessage.textContent = constants[getLanguage()].descriptionMessage;
    descriptionLabel.textContent = constants[getLanguage()].description;
    addButton.textContent = constants[getLanguage()].save;

    togglePassword.addEventListener("click", function (e) {
      // toggle the type attribute
      const type = password.getAttribute("type") === "password" ? "text" : "password";
      password.setAttribute("type", type);
      // toggle the eye / eye slash icon
      this.classList.toggle("bi-eye");
    });
    closeButton.addEventListener("click", (e) => {
      e.preventDefault();
      sendPlatformMessage({
        command: "bgCloseNotificationBar",
      });
      // chrome.tabs.getCurrent(ownTab => {
      //   chrome.tabs.sendMessage(ownTab.id, {status: 200, action: 'doClose', data: null}, data => {
      //     ('frame got data');
      //     // process data here
      //   });
      // });
    });
  }
  /*==================== FUNCTIONS ====================*/
  function getLanguage() {
    const lang = navigator.language;
    if (lang === "en-US") {
      return "en";
    }
    return "de";
  }

  function sendPlatformMessage(msg) {
    chrome.runtime.sendMessage(msg);
  }
});
