// SELECTORS
const btnGenerate = document.querySelector("#generate-btn");
const btnClose = document.querySelector("#close-btn");
// VARIABLES
let activeTab = "password";
const characters = {
  words: "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz",
  numbers: "0123456789",
  specials: "!@#$%&*()?/[]{}",
};
let passwordLength = 22;
let numberCharactersLength = 6;
let symbolsCharacterLength = 5;
// let separatorCharacterLength = 0;
// let separatorSymbol = "hyphen";

const constants = {
  en: {
    buttonText: "Use suggested password"
  },
  de: {
    buttonText: "Verwenden Sie das vorgeschlagene Passwort"
  },
};
// FUNCTIONS
function getLanguage() {
  const lang = navigator.language;
  if (lang === "en-US") {
    return "en";
  }
  return "de";
}

function getRandomCharacter(min, max) {
  return Math.floor(Math.random() * (max - min + 1)) + min;
}

function generateCharacters(characterType, characterLength, characters) {
  let generatedCharacters = "";
  const characterSet = characters[characterType];

  for (let i = 0; i < characterLength; i++) {
    generatedCharacters += characterSet[getRandomCharacter(0, characterSet.length - 1)];
  }

  return generatedCharacters;
}

function shuffleString(array) {
  return array
    .sort(() => {
      return 0.5 - Math.random();
    })
    .join("");
}

function generateNormalPassword() {
  if (passwordLength > 0) {
    const wordsCharactersLength = passwordLength - numberCharactersLength - symbolsCharacterLength;
    let password = "";
    let generatedCharacters = "";

    generatedCharacters += generateCharacters("words", wordsCharactersLength, characters);
    generatedCharacters += generateCharacters("numbers", numberCharactersLength, characters);
    generatedCharacters += generateCharacters("specials", symbolsCharacterLength, characters);

    password = shuffleString([...generatedCharacters]).slice(0, passwordLength);
    btnGenerate.textContent = "Regenerate password";

    return password;
  }
}
/*
function generatePhrasePassword() {
  if (separatorCharacterLength > 0) {
    const words = new GenerateWord(separatorCharacterLength, separatorSymbol);
    btnGenerate.textContent = "Regenerate password";
    return words.getFullPassword();
  }
}
*/
// EVENTS
/*========== CLOSE BUTTON ==========*/
btnClose.addEventListener("click", () => {
  //
  sendPlatformMessage({
    command: "closepass",
    data: "",
  });
});
/*========== REGENERATE BUTTON ==========*/
btnGenerate.addEventListener("click", () => {
  //
  const password = generateNormalPassword();

  sendPlatformMessage({
    command: "passwordGenerated",
    data: password,
  });
});

class GenerateWord {
  separatorSymbols = {
    hyphen: "-",
    dashed: " - ",
    como: ",",
  };
  constructor(wordNumber, separator) {
    this.wordNumber = wordNumber;
    this.separator = separator;
  }
  getRandomInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
  }
  GenerateWord(n) {
    const data1 = ["a", "e", "i", "o", "u"];
    const data2 = [
      "b",
      "c",
      "d",
      "f",
      "g",
      "h",
      "j",
      "k",
      "l",
      "m",
      "n",
      "p",
      "q",
      "r",
      "s",
      "t",
      "v",
      "w",
      "x",
      "y",
      "z",
    ];
    const data3 = [
      "bl",
      "br",
      "cl",
      "cr",
      "dr",
      "dw",
      "fl",
      "fr",
      "gl",
      "gr",
      "gw",
      "kn",
      "kr",
      "kw",
      "mr",
      "ph",
      "pl",
      "pn",
      "pr",
      "ps",
      "sc",
      "sh",
      "sk",
      "sl",
      "sm",
      "sn",
      "sp",
      "st",
      "sv",
      "sw",
      "tr",
      "ts",
      "wh",
    ];
    let str = "";
    let last;
    for (let i = 0; i < n; i++) {
      let type = this.getRandomInt(1, 10);
      //avoiding some cases
      if (last == 3) type = 1;
      if (last == 2) type = 1;
      if (last == 1 && this.getRandomInt(1, 2) == 1) type = 2;
      //generate
      if (type < 4) {
        //40%
        str += data1[this.getRandomInt(0, data1.length - 1)];
        last = 1;
      } else if (type < 9) {
        //40%
        str += data2[this.getRandomInt(0, data2.length - 1)];
        last = 2;
      } else {
        //20%
        str += data3[this.getRandomInt(0, data3.length - 1)];
        last = 3;
      }
    }
    str = str.charAt(0).toUpperCase() + str.slice(1);
    return str;
  }
  getFullPassword() {
    const localWorld = this.wordNumber;
    let str = "";
    for (let i = 0; i < localWorld; i++) {
      str += this.GenerateWord(6);
      if (i < localWorld - 1) str += this.separatorSymbols[this.separator];
    }
    return str;
  }
}

async function sendPlatformMessage(msg) {
  await chrome.runtime.sendMessage(msg);
}

btnGenerate.textContent = constants[getLanguage()].buttonText;